/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.jni;

import com.digitalpersona.onetouch.jni.AcquisitionLibrary;
import com.digitalpersona.onetouch.jni.DeviceEventHandler;
import com.digitalpersona.onetouch.jni.JniException;

public class Acquisition {
    public static final int DP_PRIORITY_HIGH = 1;
    public static final int DP_PRIORITY_NORMAL = 2;
    public static final int DP_PRIORITY_LOW = 3;
    private static AcquisitionLibrary theLibrary;
    private DeviceEventHandler handler;
    private final String serialNumber;
    private final int priority;
    private boolean subscribed;
    private boolean eventsEnabled;
    private Object handle;

    public Acquisition(String string, int n) throws JniException {
        if (theLibrary == null) {
            theLibrary = AcquisitionLibrary.getInstance();
        }
        this.serialNumber = string;
        this.priority = n;
        this.subscribed = false;
        this.eventsEnabled = false;
    }

    public synchronized native void subscribe() throws JniException;

    public synchronized native void unsubscribe() throws JniException;

    public synchronized boolean isSubscribed() {
        return this.subscribed;
    }

    public synchronized void startEvents() {
        this.eventsEnabled = true;
    }

    public synchronized void stopEvents() {
        this.eventsEnabled = false;
    }

    public synchronized boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    public DeviceEventHandler getHandler() {
        return this.handler;
    }

    public void setHandler(DeviceEventHandler deviceEventHandler) {
        this.handler = deviceEventHandler;
    }

    static {
        try {
            theLibrary = AcquisitionLibrary.getInstance();
        }
        catch (Exception exception) {
            theLibrary = null;
        }
    }
}

